//
//  AppDelegate.h
//  BT004 Test
//
//  Created by James Henderson 02/05/2014.
//  Copyright (c) 2014 Devantech Ltd. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <Foundation/Foundation.h>
#import <IOBluetooth/Bluetooth.h>
#import <IOBluetooth/IOBluetooth.h>
#import <IOBluetoothUI/IOBluetoothUI.h>
#import <IOBluetoothUI/IOBluetoothUIUserLib.h>
#import <IOBluetooth/IOBluetoothTypes.h>
#import <IOBluetooth/IOBluetoothUserLib.h>
#import <IOBluetooth/IOBluetoothUtilities.h>

@interface AppDelegate : NSObject <NSApplicationDelegate, IOBluetoothRFCOMMChannelDelegate, IOBluetoothDeviceInquiryDelegate>
{
    IOBluetoothDevice *btDevice;
    IOBluetoothRFCOMMChannel *channel;
    
    NSAlert *alert;
    NSTimer *relayStatesTimer;
    
    int whatData, modId, softVer, hardVer, relayStates;
    BOOL isRelayStates, isConnected;
    
    
    IBOutlet NSWindow *window;
    IBOutlet NSPanel *connectingPannel;
    IBOutlet NSProgressIndicator *progress;
    IBOutlet NSButton *relayButton1;
    IBOutlet NSButton *relayButton2;
    IBOutlet NSButton *relayButton3;
    IBOutlet NSButton *relayButton4;
}

// observed in interface
@property NSString *softString;
@property NSString *hardString;
@property NSString *idString;
@property NSString *deviceName;

@end
